/*
 * @(#)RERAttributeConnector.java   1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */
package ch.hslu.cm.rer.diagram;

import ch.hslu.cm.rer.model.RERAttribute;
import ch.hslu.cm.rer.model.Entity;
import java.io.IOException;
import org.jhotdraw.draw.*;
import org.jhotdraw.geom.*;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import java.awt.*;
import java.awt.geom.*;
import org.jhotdraw.draw.connector.StickyRectangleConnector;
/**
 * RERAttributeConnector.
 *
 *
 * @author Werner Randelshofer
 * @version 1.0 2006-01-18 Created.
 */
public class RERAttributeConnector extends StickyRectangleConnector {
    private RERAttribute attribute;
    private Insets2D.Double insets = new Insets2D.Double(0, 4,0,4);
    
    /**
     * Creates a new instance of RERAttributeConnector
     */
    public RERAttributeConnector() {
        
    }
    public RERAttributeConnector(Figure owner, RERAttribute attribute) {
        super(owner);
        this.attribute = attribute;
    }
    
    public void setAttribute(RERAttribute newValue) {
        attribute = newValue;
    }
    public RERAttribute getAttribute() {
        return getSimulatedEntityType().containsAttribute(attribute) ? attribute : null;
    }
    /**
     * Draws this connector.
     */
    @Override
    public void draw(Graphics2D g) {
        if (attribute == null) {
            super.draw(g);
        } else {
            Rectangle2D.Double bounds = getBounds();
            Ellipse2D.Double circle = new Ellipse2D.Double(bounds.x + bounds.width / 2 - 3, bounds.y + bounds.height / 2 - 3, 6, 6);
            g.setColor(Color.blue);
            g.fill(circle);
        }
    }
    
    @Override public void read(DOMInput in) throws IOException {
        super.read(in);
        in.openElement("Owner");
        setOwner((Figure) in.readObject(0));
        in.closeElement();
        if (in.getElementCount("Attribute") == 1) {
            in.openElement("Attribute");
            this.attribute = (RERAttribute) in.readObject(0);
            in.closeElement();
        }
    }
    
    @Override public void write(DOMOutput out) throws IOException {
        super.write(out);
        out.openElement("Owner");
        out.writeObject(getOwner());
        out.closeElement();
        if (getAttribute() != null) {
            out.openElement("Attribute");
            out.writeObject(getAttribute());
            out.closeElement();
        }
    }
    
    protected EntityFigure getEntityTypeFigure() {
        return (EntityFigure) getOwner();
    }
    protected Entity getSimulatedEntityType() {
        return getEntityTypeFigure().getSimulatedEntityType();
    }
    
    @Override
    public Rectangle2D.Double getBounds() {
        EntityFigure f = getEntityTypeFigure();
        if (f.isAttributesVisible() || attribute == null) {
            Figure attrFigure = f.getAttributeFigure(attribute);
            if (attrFigure != null) return attrFigure.getBounds();
        }
        return getEntityTypeFigure()/*.getNameCompartment()*/.getBounds();
    }
    
    @Override
    public Point2D.Double findStart(ConnectionFigure connection) {
        EntityFigure entityTypeFigure = (EntityFigure) connection.getStartConnector().getOwner();
        Figure startFigure = null;
        if (entityTypeFigure.isAttributesVisible()) {
            startFigure = entityTypeFigure.getAttributeFigure(attribute);
        }
        
        if (startFigure == null || attribute == null) {
            return super.findStart(connection);
        }
        
        Rectangle2D.Double r1 = startFigure.getBounds();
        Rectangle2D.Double etr1 = entityTypeFigure.getBounds();
        r1.x = etr1.x;
        r1.width = etr1.width;
        
        Rectangle2D.Double r2 = connection.getEndConnector().getBounds();
        
        int outcode = Geom.outcode(r1, r2);
        if ((outcode & Geom.OUT_LEFT) != 0) {
            return new Point2D.Double(r1.x + insets.left, r1.y + r1.height / 2 + insets.top);
        } else {
            return new Point2D.Double(r1.x + r1.width - insets.right, r1.y + r1.height / 2 + insets.bottom);
        }
    }
    
    @Override
    public Point2D.Double getAnchor() {
        if (attribute == null) {
            return super.getAnchor();
        } else {
        return Geom.center(getBounds());
        }
    }
    
    
    @Override
    public Point2D.Double findEnd(ConnectionFigure connection) {
        EntityFigure entityTypeFigure = (EntityFigure) connection.getEndConnector().getOwner();
        Figure endFigure = null;
        if (entityTypeFigure.isAttributesVisible()) {
            endFigure = entityTypeFigure.getAttributeFigure(attribute);
        }
        if (endFigure == null || attribute == null) {
            return super.findEnd(connection);
        }
        
        Rectangle2D.Double r1 = endFigure.getBounds();
        Rectangle2D.Double r2 = connection.getStartConnector().getBounds();
        Rectangle2D.Double etr1 = entityTypeFigure.getBounds();
        r1.x = etr1.x;
        r1.width = etr1.width;
        
        int outcode = Geom.outcode(r1, r2);
        if ((outcode & Geom.OUT_LEFT) != 0) {
            return new Point2D.Double(r1.x + insets.left, r1.y + r1.height / 2 + insets.top);
        } else {
            return new Point2D.Double(r1.x + r1.width - insets.right, r1.y + r1.height / 2 + insets.top);
        }
    }
}
